﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSFB.Constants;

namespace AZVIC.Ei8htPOS.POSFB.Pages
{
    /// <summary>
    /// Interaction logic for HeldTransactions.xaml
    /// </summary>
    public partial class HeldTransactions : Page
    {
        public HeldTransactions()
        {
            InitializeComponent();
            LoadHeldTransactions();
        }

        private void LoadHeldTransactions()
        {
            dgridHeldTransactions.ItemsSource = AppSession.HeldTransactions;
        }

        private void dgridHeldTransactions_MouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            if (sender != null)
            {
                if (dgridHeldTransactions != null && dgridHeldTransactions.SelectedItems != null && dgridHeldTransactions.SelectedItems.Count == 1)
                {
                    DataGridRow dgr = dgridHeldTransactions.ItemContainerGenerator.ContainerFromItem(dgridHeldTransactions.SelectedItem) as DataGridRow;
                    AppSession.CurrentOrders = dgr.DataContext as Orders;
                    AppSession.CurrentUser = (AppSession.CurrentOrders.UsersAccountID != null && AppSession.CurrentOrders.UsersAccountID != Guid.Empty ? UserAccountBL.GetItem(AppSession.CurrentOrders.UsersAccountID, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue) : null);
                    RemoveHeldTransaction(AppSession.CurrentOrders.UniqueID);
                    AppSession.CurrentOrders.UniqueID = Guid.Empty;
                    MasterWindow Master = new MasterWindow();
                    Master.LoadPages(new Ordering(), Menus.ORDER);
                }
            }
        }

        private void btnSelectTransaction_Click(object sender, RoutedEventArgs e)
        {
            Button btnSelectTransaction = sender as Button;
            Guid holdTransactionID = Guid.Parse(btnSelectTransaction.Tag.ToString());
            Orders curOrder = AppSession.HeldTransactions.Where(o => o.UniqueID == holdTransactionID).FirstOrDefault();
            if (curOrder != null)
            {
                AppSession.CurrentOrders = curOrder;
                AppSession.CurrentUser = (curOrder.UsersAccountID != null && curOrder.UsersAccountID != Guid.Empty ? UserAccountBL.GetItem(curOrder.UsersAccountID, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue) : null);
                RemoveHeldTransaction(AppSession.CurrentOrders.UniqueID);
                AppSession.CurrentOrders.UniqueID = Guid.Empty;
                MasterWindow Master = new MasterWindow();
                Master.LoadPages(new Ordering(), Menus.ORDER);
            }
        }

        public void RemoveHeldTransaction(Guid uniqueID)
        {
            AppSession.HeldTransactions.Remove(AppSession.HeldTransactions.Where(o => o.UniqueID == uniqueID).FirstOrDefault());
        }
    }
}
